#!/bin/sh
# ---------------------------------------------------
# Start Script for the GeoRasterViewer
#
# Environment Variable Prequisites
#
#   ORACLE_HOME     Oracle database installation home.
# ---------------------------------------------------

# Get required environment variables
if [ ! -r "$ORACLE_HOME"/jdk/bin/java ]; then
  echo "Cannot find $ORACLE_HOME/jdk/bin/java"
  echo "This file is needed to run this program"
  exit 1
fi


# Oracle JDBC and XML parser JARs:
JARS=$ORACLE_HOME/jdbc/lib/ojdbc6.jar:$ORACLE_HOME/lib/xmlparserv2.jar

# Spatial JARs:
JARS="$JARS":$ORACLE_HOME/md/jlib/sdoapi.jar
JARS="$JARS":$ORACLE_HOME/md/jlib/sdotopo.jar
JARS="$JARS":$ORACLE_HOME/md/jlib/sdoutl.jar
JARS="$JARS":$ORACLE_HOME/md/jlib/sdotype.jar

# JAI jars
JARS="$JARS":$ORACLE_HOME/ord/jlib/jai_core.jar
JARS="$JARS":$ORACLE_HOME/ord/jlib/jai_codec.jar

#XDB jars
JARS="$JARS":$ORACLE_HOME/rdbms/jlib/xdb.jar

# GeoRaster JAR:
JARS="$JARS":$ORACLE_HOME/md/demo/georaster/java/georaster_tools.jar


GEORASTERVIEWER_CLASS=oracle.spatial.georaster.tools.GeoRasterTool

#Note: JDK1.6 and up is required to run this program.
exec $ORACLE_HOME/jdk/bin/java -classpath "$JARS" $GEORASTERVIEWER_CLASS




